<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
        <style>
            /* width */
            ::-webkit-scrollbar {
                width: 5px;
            }

            /* Track */
            ::-webkit-scrollbar-track {
                box-shadow: inset 0 0 5px white;
                border-radius: 10px;
            }

            /* Handle */
            ::-webkit-scrollbar-thumb {
                background: rgb(247, 2, 2);
                border-radius: 10px;
            }

            .produk {
                border: 1px solid rgb(207, 206, 206);
                border-radius: 5px;
                width: 93%;
                height: 250px;
                position: absolute;
                overflow: auto;
                margin-top: 3px;
                background-color: white;
                z-index: 1;
            }

            a.list-group-item {
                padding: 7px;
                padding-left: 10px;
                color: black;
                border: 0px;
            }

            a.list-group-item:hover {
                background-color: red !important;
                color: white;
                font-weight: bold;
            }

            .tab tr td {
                padding: 10px !important;
            }
        </style>
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> Data {{ $data['page'] }}
                                </h3>
                            </div>
                            <div class="card-body">
                                <form class="form-inline float-right mb-2">
                                    <input class="form-control mr-sm-2" type="search" placeholder="Search"
                                        aria-label="Search" name="cari">
                                    <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                        Cari!</button>
                                </form>
                                <table class="table table-bordered table-hover myTable tab ">
                                    <thead>
                                        <tr>
                                            <th width="3%">No</th>
                                            <th>Kode Produk</th>
                                            <th width="45%">Nama Produk</th>
                                            <th>Jml. Masuk</th>
                                            <th>Satuan</th>
                                            <th>Tgl. Masuk</th>
                                            {{-- <th>Opsi</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody id="view">
                                        @forelse ($stok as $s)
                                            <tr>
                                                <td class="text-center"> {{ $no++ }}</td>
                                                <td>{{ $s->produk->kd_produk }}</td>
                                                <td>{{ $s->produk->nm_produk }}</td>
                                                <td class="text-center">{{ $s->jml_masuk }}</td>
                                                <td class="text-center">{{ $s->produk->satuan->nm_satuan }}</td>
                                                <td>{{ tgl_inf($s->created_at) }} </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="12" class="text-center text-danger"> Data
                                                    masih
                                                    kosong.
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $stok->links('components.admin.pagination') }}
                            </div>
                        </div><!-- /.card -->
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fa fa-database text-danger"></i> Input
                                    {{ $data['page'] }}</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="">Scan Barcode / Cari Nama Produk</label>
                                    <input type="text" name="cari_data" id="cari_data"
                                        class="form-control form-control-lg" placeholder="Barcode...." autofocus>
                                    <div class="show">

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <hr>
                                        <table style="width: 100%; ">
                                            <tr>
                                                <th width="30%">Kode</th>
                                                <th>: <span id="kd"></span></th>
                                            </tr>
                                            <tr>
                                                <th>Nama</th>
                                                <th>: <span id="nm"></span></th>
                                            </tr>
                                        </table>
                                        <hr>
                                    </div>
                                </div>
                                <input type="hidden" name="" id="idp">
                                <div class="form-group">
                                    <label for=""> Stok Masuk</label>
                                    <input type="text" name="jml" id="jml" class="form-control numbers"
                                        disabled placeholder="0">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                    Reset</button>
                                <button class="btn btn-primary float-right simpan"><i class="fa fa-save"></i>
                                    Simpan</button>
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->

                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/stok.js"></script>
    </x-slot:foot>
</x-kasir.contents>
